<?php

namespace JNews\WEBSTORIES;

/**
 * @author Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use JNews\WEBSTORIES\Element\Webstories_Element;

/**
 * Class Init
 *
 * @package JNEWS_WEBSTORIES
 */
class Init {
	/**
	 * Instance of Init
	 *
	 * @var Init
	 */
	private static $instance;

	/**
	 * Instance
	 *
	 * @return void
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Init ) ) {
			self::$instance             = new Init();
			self::$instance->webstories = Webstories_Element::instance();
		}

		return self::$instance;
	}

	/**
	 * @var string
	 */
	private $endpoint = 'ajax-request';

	/**
	 * Init constructor.
	 */
	private function __construct() {
		$this->setup_hook();
		$this->jnews_webstories_load_textdomain();
	}

	/**
	 * Setup hook
	 */
	protected function setup_hook() {
		add_action( 'wp_print_styles', array( $this, 'story_scripts' ) );
		add_action( 'parse_request', array( $this, 'ajax_parse_request' ) );
		if ( is_admin() || $this->is_elementor_editor() ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'load_admin_style' ), 99 );
			add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'load_admin_style' ), 99 );
		}
		add_action( 'wp_ajax_jnews_webstories_get_category', array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_category' ) );
		add_action( 'wp_ajax_jnews_webstories_get_tag', array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_tag' ) );
		add_filter( 'jnews_default_query_webstories_args', array( 'JNews\WEBSTORIES\Helper', 'jnews_default_webstories_query' ), 10, 2 );
	}

	/**
	 * Ajax request parse
	 *
	 * @param object $wp
	 */
	public function ajax_parse_request( $wp ) {
		if ( array_key_exists( $this->endpoint, $wp->query_vars ) ) {
			add_filter( 'wp_doing_ajax', '__return_true' );
			$action = $wp->query_vars['action'];

			if ( 'jnews_webstories_ajax' === $action ) {
				$this->webstories_ajax();
			}
			do_action( 'jnews_ajax_' . $action );
		}
	}

	/**
	 * Load Admin Style CSS
	 */
	public function load_admin_style() {
		wp_enqueue_style( 'jnews-webstories-admin', JNEWS_WEBSTORIES_URL . '/assets/css/admin/admin-style.css', null, JNEWS_WEBSTORIES_VERSION );
	}

	/**
	 * Story scripts
	 *
	 * @return void
	 */
	public function story_scripts() {
		wp_register_style( 'jnews-webstories', JNEWS_WEBSTORIES_URL . '/assets/css/plugin.css', array( 'jnews-global-slider' ), JNEWS_WEBSTORIES_VERSION );
		wp_register_script( 'jnews-webstories', JNEWS_WEBSTORIES_URL . '/assets/js/plugin.js', array( 'tiny-slider-noconflict' ), JNEWS_WEBSTORIES_VERSION, true );

		if ( is_user_logged_in() ) {
			wp_enqueue_style( 'jnews-webstories' );
			wp_enqueue_script( 'jnews-webstories' );
		}

		wp_localize_script( 'jnews-webstories', 'jnewsWebstoriesLocal', $this->localize_script() );
	}

	/**
	 * Webstories ajax
	 *
	 * @return void
	 */
	public function webstories_ajax() {

		if ( ! empty( $_POST['data']['nonce'] ) && wp_verify_nonce( $_POST['data']['nonce'], 'jnews-webstories-nonce' ) ) {
			$web_story_id = isset( $_POST['data']['id'] ) ? absint( wp_unslash( $_POST['data']['id'] ) ) : null;

			if ( empty( $web_story_id ) ) {
				exit();
			}

			if ( 'web-story' !== get_post_type( $web_story_id ) ) {
				exit();
			}

			wp_send_json_success( get_the_permalink( $web_story_id ) );
		}
	}

	/**
	 * Check if page is elementor editor
	 *
	 * @return void
	 */
	public function is_elementor_editor() {
		return is_admin() && ( isset( $_GET['action'] ) && sanitize_text_field( $_GET['action'] ) === 'elementor' );
	}

	/**
	 * Localize webstories nonce
	 *
	 * @return void
	 */
	public function localize_script() {
		return array(
			'nonce' => wp_create_nonce( 'jnews-webstories-nonce' ),
		);
	}

	/**
	 * Webstories text domain
	 *
	 * @return void
	 */
	private function jnews_webstories_load_textdomain() {
		load_plugin_textdomain( JNEWS_WEBSTORIES_DIR, false, JNEWS_WEBSTORIES_DIR . '/languages/' );
	}
}
